<?php

\set_time_limit(500);
\ini_set('max_execution_time', '500');

use Erlage\Photogram\System;
use Erlage\Photogram\Tools\FileSystemUtils;
use Erlage\Photogram\Data\Dtos\Common\DisplayItemDTO;

require 'bootstrap.php';

System::init();

$userFolder = DIR_NAME_UPLOADS . DIRECTORY_SEPARATOR . DisplayItemDTO::FILESPACE_USER;
$postFolder = DIR_NAME_UPLOADS . DIRECTORY_SEPARATOR . DisplayItemDTO::FILESPACE_POST;
$collectionFolder = DIR_NAME_UPLOADS . DIRECTORY_SEPARATOR . DisplayItemDTO::FILESPACE_COLLECTION;

$placeholderFolder = DIR_NAME_UPLOADS . DIRECTORY_SEPARATOR . DisplayItemDTO::FILESPACE_PLACEHOLDER;

foreach (FileSystemUtils::filesRecursive($placeholderFolder) as $file)
{
    if ($file -> isFile() && \in_array($file -> getExtension(), array('png', 'jpeg', 'jpg', 'webp')))
    {
        $filePath = $file -> getPath() . DIRECTORY_SEPARATOR . $file -> getFilename();
        $compressedPath = \str_replace($file -> getFilename(), 'c_' . $file -> getFilename(), $filePath);

        $handle = new \Verot\Upload\Upload($filePath);

        // create and save a compressed version of image

        $handle -> image_resize = true;
        $handle -> image_ratio_y = true;
        $handle -> image_x = 150;

        $handle -> png_compression = 1;
        $handle -> jpeg_quality = 90;
        $handle -> webp_quality = 90;

        $handle -> file_name_body_pre = 'c_';

        $handle -> process($file -> getPath());
    }
}

foreach (FileSystemUtils::filesRecursive($userFolder) as $file)
{
    if ($file -> isFile() && \in_array($file -> getExtension(), array('png', 'jpeg', 'jpg', 'webp')))
    {
        $filePath = $file -> getPath() . DIRECTORY_SEPARATOR . $file -> getFilename();
        $compressedPath = \str_replace($file -> getFilename(), 'c_' . $file -> getFilename(), $filePath);

        $handle = new \Verot\Upload\Upload($filePath);

        // create and save a compressed version of image

        $handle -> image_resize = true;
        $handle -> image_ratio_y = true;
        $handle -> image_x = 150;

        $handle -> png_compression = 1;
        $handle -> jpeg_quality = 90;
        $handle -> webp_quality = 90;

        $handle -> file_name_body_pre = 'c_';

        $handle -> process($file -> getPath());
    }
}

foreach (FileSystemUtils::filesRecursive($postFolder) as $file)
{
    if ($file -> isFile() && \in_array($file -> getExtension(), array('png', 'jpeg', 'jpg', 'webp')))
    {
        $filePath = $file -> getPath() . DIRECTORY_SEPARATOR . $file -> getFilename();
        $compressedPath = \str_replace($file -> getFilename(), 'c_' . $file -> getFilename(), $filePath);

        $handle = new \Verot\Upload\Upload($filePath);

        // create and save a compressed version of image

        $handle -> image_resize = true;
        $handle -> image_ratio_y = true;
        $handle -> image_x = 400;

        $handle -> png_compression = 1;
        $handle -> jpeg_quality = 90;
        $handle -> webp_quality = 90;

        $handle -> file_name_body_pre = 'c_';

        $handle -> process($file -> getPath());
    }
}

foreach (FileSystemUtils::filesRecursive($collectionFolder) as $file)
{
    if ($file -> isFile() && \in_array($file -> getExtension(), array('png', 'jpeg', 'jpg', 'webp')))
    {
        $filePath = $file -> getPath() . DIRECTORY_SEPARATOR . $file -> getFilename();
        $compressedPath = \str_replace($file -> getFilename(), 'c_' . $file -> getFilename(), $filePath);

        $handle = new \Verot\Upload\Upload($filePath);

        // create and save a compressed version of image

        $handle -> image_resize = true;
        $handle -> image_ratio_y = true;
        $handle -> image_x = 200;

        $handle -> png_compression = 2;
        $handle -> jpeg_quality = 70;
        $handle -> webp_quality = 70;

        $handle -> file_name_body_pre = 'c_';

        $handle -> process($file -> getPath());
    }
}

echo 'Done, you can now close this tab.';

\unlink(__FILE__);
